# Working with JSON in Java

## 1. Introduction to JSON

**JSON (JavaScript Object Notation)** is a lightweight data-interchange format that is both human-readable and machine-friendly.  
It is widely used in modern applications to exchange structured information between clients and servers.

Key characteristics of JSON:

- Data is represented as key–value pairs.
- Supports nested structures (objects within objects, arrays of objects, etc.).
- Commonly used in REST APIs and web services.

**Example JSON object:**

```json
{
  "id": 1,
  "title": "Hello World",
  "body": "This is an example post."
}
```

## 2. What the Code Does

The provided Java program demonstrates how to:

1. **Connect to a remote server** using `HttpURLConnection`.
2. **Download JSON-formatted data** from the URL [https://jsonplaceholder.typicode.com/posts](https://jsonplaceholder.typicode.com/posts).
3. **Read the server response** into a string using `BufferedReader`.
4. **Parse the response** using the `JSONArray` and `JSONObject` classes (from the `org.json` library).
5. **Extract specific information** (in this case, post titles) from the JSON array.
6. **Print results**:

   - Total number of posts retrieved.
   - The title of each post.

**Output Example:**

```
# of posts: 100
Titles:
sunt aut facere repellat provident occaecati excepturi optio reprehenderit
qui est esse
...
```

## 3. Proposed Extension

As an extension exercise, try fetching **real-world earthquake data** from the U.S. Geological Survey (USGS).
They provide live JSON feeds with earthquake information here:
👉 [https://earthquake.usgs.gov/earthquakes/feed/v1.0/geojson.php](https://earthquake.usgs.gov/earthquakes/feed/v1.0/geojson.php)

### Suggested Task

1. Choose one of the **GeoJSON feeds** (e.g., "Significant Earthquakes – Past Day").
2. Fetch and parse the data similarly to the given code.
3. Extract and display for each earthquake:

   - Magnitude
   - Location
   - Time (convert the timestamp to a human-readable date)

4. Print summary information (e.g., total number of earthquakes retrieved).

**Example Goal Output:**

```
# of earthquakes: 12
Magnitude: 5.4 | Location: 50km SE of XYZ | Time: 2025-09-25 14:30:00
Magnitude: 6.1 | Location: Near Coast of ABC | Time: 2025-09-25 03:10:00
...
```

This will give you hands-on practice with:

- Parsing nested JSON objects (`features`, `properties`, etc.).
- Extracting meaningful real-time data.
- Applying the same logic to different APIs.
